﻿$(document).ready(function () {
    questionTranslationEditor.$context = $("#translate");
    questionTranslationEditor.initialize();
    questionTranslationEditor.bindGeneralEvents();
    questionTranslationEditor.bindQuestionEvents();
});

var questionTranslationEditor = {
    $context: null,
    questionnaireId: 0,
    initialize: function () {
        $(".v-qeRichEditText", questionTranslationEditor.$context).a4richTextEditor({
            inline: true,
            library: true,
            piping: true,
            piping_system: true,
            singleEditor: true
        });
    },
    bindGeneralEvents: function () {
        IsAutoTranslateLicenseActive();

        $(".v-switchQuestion", questionTranslationEditor.$context).on("click", function () {
            questionTranslationEditor.switchQuestion($(this).attr("data-type"));
        });

        $(".v-cancel").on("click", function () {
            questionTranslationEditor.updateQuestionEditor();
        });

        $(".v-saveQuestion").on("click", function () {
            $.when(questionTranslationEditor.saveQuestion())
                .then(function () { questionTranslationEditor.updateQuestionEditor(); });
        });

        $(".v-saveQuestionAndNext").on("click", function () {
            $.when(questionTranslationEditor.saveQuestion())
                .then(function () { questionTranslationEditor.switchQuestion("next"); });
        });

        $(".v-autoTranslate").on("click", function () {
            if ($(this).hasClass('disabled')) {
                return;
            };

            a4.busyBoxEnabled = true;

            var questionId = $(".v-questionSelector").val();
            var translateLanguage = $(".v-translateLanguage").val();
            var referenceLanguage = $(".v-referenceLanguage").val();

            args = {
                questionId: questionId,
                referenceLanguageCode: referenceLanguage,
                translateLanguageCode: translateLanguage
            };

            modalDialog.showConfirmDialog(confirmTranslateQuestionResources,
                function () {
                    a4.callServerMethod(a4.getSurveyAction("AutoTranslateQuestions", "Translate", { surveyId: questionTranslationEditor.questionnaireId }), args,
                        function (result) {
                            a4.showSuccessMessage(resources.SuccessTranslateQuestions, 2000);
                            questionTranslationEditor.updateQuestionEditor();
                            
                            if (typeof surveyMenu != 'undefined') {
                                surveyMenu.refresh();
                            }
                        },
                        function (result) {
                            if (result == undefined) {
                                return;
                            }

                            var parsedData = JSON.parse(result.responseText);

                            if (parsedData.IsApplicationException) {
                                modalDialog.showCustomDialog(
                                    parsedData.Message,
                                    resources.UnableToAutoTranslate,
                                    [{ Text: resources.CloseButton, LinkButton: true, Action: function () { modalDialog.close(); } }],
                                    null,
                                    null,
                                    true);
                                questionTranslationEditor.updateQuestionEditor();
                            } else {
                                a4.showErrorMessage(parsedData.Message, 2000);
                            }
                        }, { dataType: "html" });
                }, 220, 500, false, {});
        });

        $(".v-print").on("click", function () {
            window.print();
        });
        
        $(".v-translateLanguage, .v-referenceLanguage, .v-questionSelector", questionTranslationEditor.$context).each(function () {
            $(this).data("prev", $(this).val());
        });

        $(".v-translateLanguage, .v-referenceLanguage, .v-questionSelector", questionTranslationEditor.$context).on("change", function () {
            var select = $(this);
            var currentValue = select.val();
            var previousValue = select.data("prev");

            if (HasUnsavedChanges()) {
                modalDialog.showUnsavedChangesDialog(function () {
                    select.val(previousValue);
                    $.when(questionTranslationEditor.saveQuestion())
                        .then(function () {
                            select.val(currentValue);
                            select.data("prev", currentValue);
                            questionTranslationEditor.updateQuestionEditor();
                        });
                }, function () {
                    select.data("prev", currentValue);
                    questionTranslationEditor.updateQuestionEditor();
                }, function () {
                    select.val(previousValue);
                });
            } else {
                select.data("prev", currentValue);
                questionTranslationEditor.updateQuestionEditor();
            }
        });
    },
    bindQuestionEvents: function () {
        questionTranslationEditor.$context.on("change", ".v-translationTextBox", function () {
            $(this).attr("data-changed", "true");
        });

        $(".v-multiEditButton").on("click", function () {
            var container = $(this).closest("table");
            var text = $(".v-translationTextBox, .v-imageSelector", container).map(function () {
                return htmlDecode(a4.getInputValue($(this))).trim();
            }).get().join("\n");

            modalDialog.renderSimpleFormDialog(multiEditResources, [{ Label: null, Name: "Items", Value: text, Type: "textarea", "Style": "width: 100%; box-sizing: border-box; border: 0;" }], function (items) {
                var values = items["Items"].split('\n');
                var count = 0;

                $(".v-translationTextBox, .v-imageSelector", container).each(function () {
                    if ($(this).hasClass('v-imageSelector')) {
                        $(this).val(values[count]);
                        $(this).attr("data-changed", "true");
                    } else {
                        $(this).a4richTextEditor("setContent", values[count]);
                    }
                    count++;
                });
            });
        });
    },
    switchQuestion: function (type) {
        var $questionsMenu = $(".v-questionSelector", questionTranslationEditor.$context);
        var $selectedOption = $questionsMenu.find(":selected");

        var $switchToOption = type == "next" ? $selectedOption.next($("option", $questionsMenu)) : $selectedOption.prev($("option", $questionsMenu));

        if ($switchToOption.length > 0) {
            $questionsMenu.val($switchToOption.val());
            $questionsMenu.trigger("change");
        }
    },
    updateQuestionEditor: function () {
        var $translationEdition = $("#questionTranslationEditor .v-translatorContainer");
        var questionId = $(".v-questionSelector").val();
        var translateLanguage = $(".v-translateLanguage").val();
        var referenceLanguage = $(".v-referenceLanguage").val();

        args = {
            questionId: questionId,
            referenceLanguageCode: referenceLanguage,
            translateLanguageCode: translateLanguage
        };

        a4.callServerMethod(a4.getSurveyAction("GetQuestionEditor", "Translate", { surveyId: questionTranslationEditor.questionnaireId }), args,
            function (result) {
                $translationEdition[0].innerHTML = result;

                questionTranslationEditor.initialize();
                questionTranslationEditor.bindQuestionEvents();
                a4ImageSelector.bindElements($("#questionTranslationEditor"));
            }, null, { dataType: "html" });
    },
    saveQuestion: function () {
        var questionTitle = a4.getInputValue($(".v-translatorContainer .v-questionTitle", questionTranslationEditor.$context)) || "";
        var questionText = a4.getInputValue($(".v-translatorContainer .v-questionText", questionTranslationEditor.$context)) || "";
        var questionShortText = a4.getInputValue($(".v-translatorContainer .v-questionShortText", questionTranslationEditor.$context)) || "";
        var settingTexts = {};
        var variableSettingTexts = {};
        var choiceTexts = {};
        var choiceSettings = {};
        $(".v-choiceText[data-changed='true']", questionTranslationEditor.$context).map(function () { return TextObject(choiceTexts, $(this)); });
        $(".v-settingText[data-changed='true']", questionTranslationEditor.$context).map(function () { return TextObject(settingTexts, $(this)); });

        $(".v-choiceSetting[data-changed='true']", questionTranslationEditor.$context).map(function () { return ChoiceSettingObject(choiceSettings, $(this)); });

        if ($(".v-columnSetting", questionTranslationEditor.$context).length > 0) {
            SetColumnSettings(settingTexts);
        }
        if ($(".v-translatorControl .v-rowSetting", questionTranslationEditor.$context).length > 0) {
            SetRowSettings(settingTexts);
        }

        SetVariableSettingTexts(variableSettingTexts);

        var questionId = $(".v-questionSelector", questionTranslationEditor.$context).val();
        var language = $(".v-translateLanguage", questionTranslationEditor.$context).val();

        var args = {
            questionId: questionId,
            questionTitle: questionTitle.trim(),
            questionText: questionText.trim(),
            questionShortText: questionShortText.trim(),
            settingTexts: $.isEmptyObject(settingTexts) ? null : settingTexts,
            variableSettingTexts: $.isEmptyObject(variableSettingTexts) ? null : variableSettingTexts,
            choiceTexts: $.isEmptyObject(choiceTexts) ? null : choiceTexts,
            choiceSettings: $.isEmptyObject(choiceSettings) ? null : choiceSettings,
            toLanguage: language
        };

        return a4.callServerMethod(a4.getSurveyAction("UpdateQuestion", "Translate", { surveyId: questionTranslationEditor.questionnaireId }), args, function (result) {
            a4.showSuccessMessage(resources.SuccessMessage, 2000);

            // For save and next
            $(".v-translationTextBox[data-changed='true']", questionTranslationEditor.$context).attr("data-changed", "false");

            surveyMenu.refresh();
        });
    }
}

function TextObject(texts, $textBox) {
    var key = $textBox.attr("data-key");
    var value = a4.getInputValue($textBox).trim();

    if ($textBox.hasClass("v-encodeHtml")) {
        value = a4.encodeHtml(value);
    }

    texts[key] = value;
}

function ChoiceSettingObject(choiceSettings, $textBox) {
    var key = $textBox.data("key");
    var settingName = $textBox.data("settingname");

    if (choiceSettings[key] == null) choiceSettings[key] = {};

    choiceSettings[key][settingName] = a4.getInputValue($textBox).trim();
}

function SetVariableSettingTexts(variableSettingTexts) {
    var variableIds = new Array();
    $(".v-variableSettingText[data-changed='true']", questionTranslationEditor.$context).each(function () {
        variableIds.push($(this).attr("data-variableid"));
    });

    variableIds = _.uniq(_.compact(variableIds));

    _.each(variableIds, function (id) {
        var settingTexts = {};
        $(".v-variableSettingText[data-variableid='" + id + "'][data-changed='true']", questionTranslationEditor.$context).map(function () { return TextObject(settingTexts, $(this)); });
        variableSettingTexts[id] = JSON.stringify(settingTexts);
    });
}

function SetRowSettings(settingTexts) {
    var translatorControl = $(".v-translatorControl[data-type='rows']", questionTranslationEditor.$context);
    var rowCount = parseInt(translatorControl.attr("data-items"), 10);
    var rowSettings = new Array(rowCount);

    for (var i = 0; i < rowCount; i++) {
        rowSettings[i] = {};
    }

    $(".v-rowSetting", translatorControl).each(function () {
        var position = $(this).attr("data-position");
        var key = $(this).attr("data-key");
        rowSettings[position][key] = a4.getInputValue($(this)).trim();
    });

    settingTexts["RowTranslatableSettings"] = JSON.stringify(rowSettings);
}

function SetColumnSettings(settingTexts) {
    var translatorControl = $(".v-translatorControl[data-type='columns']", questionTranslationEditor.$context);
    var columnsCount = translatorControl.length == 0 ? 1 : parseInt(translatorControl.attr("data-items"), 10);
    var columnSettings = new Array(columnsCount);

    for (var i = 0; i < columnsCount; i++) {
        columnSettings[i] = {};
    }

    $(".v-columnSetting").each(function () {
        var position = $(this).attr("data-position") || '0';
        var key = $(this).attr("data-key");

        columnSettings[position][key] = a4.getInputValue($(this)).trim();
    });

    settingTexts["ColumnTranslatableSettings"] = JSON.stringify(columnSettings);
}

function HasUnsavedChanges() {
    return $(".v-translationTextBox[data-changed='true']", questionTranslationEditor.$context).length > 0;
}

function IsAutoTranslateLicenseActive() {
    a4.callServerMethod(a4.getSurveyAction("IsAutoTranslateLicenseActive", "Translate", null), null,
        function (result) {
            if (!result.active) {
                $(".v-autoTranslate").hide();
            }
        }
        , null, { dataType: "json" });
}